IF EXISTS ( SELECT * FROM SYS.OBJECTS WHERE NAME ='EST_PROD_TRANSF_PRODUTOS')
BEGIN 
	DROP TABLE EST_PROD_TRANSF_PRODUTOS
END
go
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[P_GERA_RESSUPRIMENTO_POOL_DEPOSITOS]') AND type in (N'P', N'PC'))
	DROP PROCEDURE [dbo].[P_GERA_RESSUPRIMENTO_POOL_DEPOSITOS]
GO
  
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/*
=======================================================================================
'Nvel Classificao.: INFORMAO RESTRITA
'Verso..............: 2110062316
'Job.................:  
'Nome................: P_GERA_RESSUPRIMENTO_POOL_DEPOSITOS 
'Objetivo............: 
'Tabelas.............: 
'Dt Criao..........: 
'Dt Ult Alteraco....: 06/10/2021
'Alterado por........: Marcos Barros 
'Criado por..........: 
'=======================================================================================
2110062316 - Adicionado validao EST_PROD_TRANSF_PRODUTOS linha 1
*/

CREATE PROCEDURE [dbo].[P_GERA_RESSUPRIMENTO_POOL_DEPOSITOS] (@CD_EMP INT =1, @AGENDA INT=NULL)
AS
set nocount on; 

DECLARE @POOL_RESSUPRIMENTO TINYINT;

DECLARE  @CD_AGENDA				int, 
		 @CD_CTRDEPO		int,
		 @ORDEM				int, 
		 @CdCtrDepoSemPool int,
		 @FilialDeposito   int,
		 @FlDeposito		int; 

DECLARE	@HOJE					DATETIME,
		@DIAS_RES_ACRESCENTAR	TINYINT,
		@DIA_SEMANA				TINYINT;

	
	SET @DIAS_RES_ACRESCENTAR=ISNULL((SELECT DIAS_RES_ACRESCENTAR FROM PRC_EMP WHERE CD_EMP = @CD_EMP),0);

	SELECT	
		@HOJE = CONVERT(CHAR(10),GETDATE() + @DIAS_RES_ACRESCENTAR,120),
		@DIA_SEMANA = DATEPART(weekday,@HOJE); 

	SET @POOL_RESSUPRIMENTO= ISNULL((SELECT VALOR FROM PRC_EMP_CONFIG 
											WHERE CD_EMP = @CD_EMP AND CD_CHAVE = 'UTILIZA_POOL_RESSUPRIMENTO'),0);
 
IF @POOL_RESSUPRIMENTO=0
	RETURN

-----------------------------------------------------------------------------------	  
-----------------------------------------------------------------------------------	  	
 
	 
-----------------------------------------------------------------------------------
	print '------------  Pendencias de entrada -----------------'
	 
	INSERT INTO GLB_EXEC_LOG_ROTINAS (DT_LOG,DT_HR_LOG,MSG_LOG,OPERADOR,LINHA,ROTINA,ROTINA_AUX,PROCESSO)	
		VALUES (GETDATE(),GETDATE(),'Executa pendencia de entrada','EXECUTE',75,'P_GERA_RESSUPRIMENTO_POOL_DEPOSITOS','P_EST_PROD_PENDENCIA_ENTRADA','RESSUPRIMENTO')

	 EXEC P_EST_PROD_PENDENCIA_ENTRADA 

-----------------------------------------------------------------------------------	
-- GERACAO DOS RESSUPRIMENTOS CONFIGURADOS NO POOL  
-----------------------------------------------------------------------------------	  

	print '------------  Gera necessidades Pool -----------------'
	print '------------  '+ convert(varchar, getdate(),108) +'-----------------';
	
	INSERT INTO GLB_EXEC_LOG_ROTINAS (DT_LOG,DT_HR_LOG,MSG_LOG,OPERADOR,LINHA,ROTINA,ROTINA_AUX,PROCESSO)	
		VALUES (GETDATE(),GETDATE(),'Gera necessidades Pool','EXECUTE',87,'P_GERA_RESSUPRIMENTO_POOL_DEPOSITOS','P_GERA_RESSUPRIMENTO_POOL','RESSUPRIMENTO')
 	EXEC P_GERA_RESSUPRIMENTO_POOL @CD_EMP

-----------------------------------------------------------------------------------	  
	
	INSERT INTO GLB_EXEC_LOG_ROTINAS (DT_LOG,DT_HR_LOG,MSG_LOG,OPERADOR,LINHA,ROTINA,ROTINA_AUX,PROCESSO)	
		VALUES (GETDATE(),GETDATE(),'Cria tabela EST_PROD_TRANSF_PRODUTOS','CREATE',93,'P_GERA_RESSUPRIMENTO_POOL_DEPOSITOS','','RESSUPRIMENTO')

	IF EXISTS ( SELECT * FROM SYS.OBJECTS
				WHERE NAME ='EST_PROD_TRANSF_PRODUTOS')
		BEGIN 
			DROP TABLE EST_PROD_TRANSF_PRODUTOS
		END
	 
	CREATE TABLE EST_PROD_TRANSF_PRODUTOS (CD_EMP INT,
												CD_PROD INT ,
												HABILITA INT,
												[QT_UNI_RESSUPRIMENTO] [money] NULL,
												[FLAG_RESSUPRIMENTO_CAIXA_FECHADA] [int] NULL,
												STS_PROD INT,
												CD_FABRIC INT,
												COMPRA_POR_SUPRIMENTO int
												PRIMARY KEY (CD_PROD,CD_EMP )) 

-----------------------------------------------------------------------------------	  

BEGIN TRY
	
	INSERT INTO GLB_EXEC_LOG_ROTINAS (DT_LOG,DT_HR_LOG,MSG_LOG,OPERADOR,LINHA,ROTINA,ROTINA_AUX,PROCESSO)	
		VALUES (GETDATE(),GETDATE(),'Carrega o agendamento ','SELECT',111,'P_GERA_RESSUPRIMENTO_POOL_DEPOSITOS','','RESSUPRIMENTO')

	declare c_Agendas CURSOR FAST_FORWARD FOR
		
		SELECT DISTINCT A.CD_AGD_RESSUP, 
						ISNULL(A.ORDEM_RESSUP,99) ORDEM_RESSUP,
						CASE WHEN D.CD_EMP IS NULL THEN P.CD_CTR_DEPO ELSE 0 END POOL_DEPO,
						A.CD_FILIAL_DEPO 
				FROM 
					EST_PROD_RESSUP_AGENDAMENTO A
					JOIN PRC_FILIAL_DEPOSITO P ON 
					A.CD_EMP = P.CD_EMP AND
					A.CD_FILIAL_DEPO = P.CD_FILIAL

					left JOIN EST_PROD_RESSUP_AGENDAMENTO_PRC_FILIAL_DEPOSITO D ON 
					A.CD_EMP		 = D.CD_EMP			AND
					A.CD_AGD_RESSUP	 = D.CD_AGD_RESSUP	AND
					A.CD_FILIAL_DEPO = D.CD_FILIAL_DEPO
				where 
					(CASE	WHEN @DIA_SEMANA =1	THEN A.DOMINGO
							WHEN @DIA_SEMANA =2 THEN A.SEGUNDA  
							WHEN @DIA_SEMANA =3 THEN A.TERCA  
							WHEN @DIA_SEMANA =4 THEN A.QUARTA
							WHEN @DIA_SEMANA =5 THEN A.QUINTA  
							WHEN @DIA_SEMANA =6 THEN A.SEXTA  
							WHEN @DIA_SEMANA =7 THEN A.SABADO END) = 1 
					AND A.CD_AGD_RESSUP = ISNULL(@AGENDA, A.CD_AGD_RESSUP)
				ORDER BY
						ISNULL(A.ORDEM_RESSUP,99), A.CD_AGD_RESSUP;

	OPEN c_Agendas
	FETCH NEXT FROM c_Agendas INTO @cd_Agenda, @ordem, @CdCtrDepoSemPool,@FlDeposito  ;

	WHILE @@FETCH_STATUS = 0
		BEGIN
	 
			TRUNCATE TABLE EST_PROD_TRANSF_PRODUTOS;

			--Aplicar os produtos da agenda
			INSERT INTO EST_PROD_TRANSF_PRODUTOS (CD_EMP,CD_PROD,HABILITA,
													QT_UNI_RESSUPRIMENTO,FLAG_RESSUPRIMENTO_CAIXA_FECHADA,STS_PROD,
													CD_FABRIC, COMPRA_POR_SUPRIMENTO) 
			SELECT 
				A.CD_EMP, 
				W.CD_PROD,
				1 HABILITA,
				y.QT_UNI_RESSUPRIMENTO,
				y.FLAG_RESSUPRIMENTO_CAIXA_FECHADA,
				y.STS_PROD,
				y.CD_FABRIC, 
				y.COMPRA_POR_SUPRIMENTO
			FROM  
				EST_PROD_RESSUP_AGENDAMENTO A 
				INNER JOIN EST_PROD_RESSUP_AGENDAMENTO_EST_PROD_FABRIC f on
				A.CD_EMP		= F.CD_EMP AND
				A.CD_AGD_RESSUP  = F.CD_AGD_RESSUP
	
				INNER JOIN EST_PROD_RESSUP_AGENDAMENTO_EST_ARV_MERC_LINHA l on
				A.CD_EMP		= L.CD_EMP AND
				A.CD_AGD_RESSUP  = L.CD_AGD_RESSUP 

				INNER JOIN EST_PROD Y on 
				F.CD_FABRIC  = Y.CD_FABRIC 

				INNER JOIN EST_PROD_EST_ARV_MERCADOLOGICA W on
				L.CD_EMP			 = W.CD_EMP AND
				L.CD_ARV_MERC_LINHA  = W.CD_ARV_MERC_LINHA AND
				Y.CD_PROD			 = W.CD_PROD
			WHERE
				A.CD_EMP	= 1
				AND A.CD_AGD_RESSUP	=1-- @cd_Agenda 
			GROUP BY 
				A.CD_EMP, 
				W.CD_PROD,
				y.QT_UNI_RESSUPRIMENTO,
				y.FLAG_RESSUPRIMENTO_CAIXA_FECHADA,
				y.STS_PROD,
				y.CD_FABRIC, 
				y.COMPRA_POR_SUPRIMENTO;  
		
		--Produtos de tabloides		
		IF EXISTS (SELECT * FROM EST_PROD_RESSUP_AGENDAMENTO 
						WHERE INCLUI_TABLOIDE=1 AND CD_AGD_RESSUP	= @cd_Agenda)
		BEGIN
			INSERT INTO EST_PROD_TRANSF_PRODUTOS (CD_EMP,CD_PROD,HABILITA,QT_UNI_RESSUPRIMENTO,
													FLAG_RESSUPRIMENTO_CAIXA_FECHADA,STS_PROD,CD_FABRIC, COMPRA_POR_SUPRIMENTO) 
			SELECT DISTINCT
				T.CD_EMP, 
				T.CD_PROD,
				1 HABILITA,
				y.QT_UNI_RESSUPRIMENTO,
				y.FLAG_RESSUPRIMENTO_CAIXA_FECHADA,
				y.STS_PROD,
				y.CD_FABRIC, 
				y.COMPRA_POR_SUPRIMENTO
			FROM
				(SELECT DISTINCT
						T.CD_EMP,
						P.CD_PROD 
					FROM 
						EST_PROD_TABLOIDE T
						INNER JOIN EST_PROD_TABLOIDE_CPL P ON 
						T.CD_EMP = P.CD_EMP AND
						T.CD_TABLOIDE = P.CD_TABLOIDE
						INNER JOIN EST_PROD_TABLOIDE_FILIAL F ON 
						T.CD_EMP		= F.CD_EMP AND
						T.CD_TABLOIDE	= F.CD_TABLOIDE
					WHERE T.FLAG_VIGENCIA=1) T
				INNER JOIN EST_PROD Y on 
				T.CD_EMP	= y.CD_EMP AND
				T.CD_PROD	= y.CD_PROD  

				LEFT JOIN EST_PROD_TRANSF_PRODUTOS TA ON 
				T.CD_EMP	= TA.CD_EMP AND
				T.CD_PROD	= TA.CD_PROD  
			WHERE
				T.CD_EMP	= @CD_EMP
				AND TA.CD_EMP IS NULL ;
		END 
			
			--Deletar dos produtos PBM
			IF EXISTS ( SELECT TOP 1 * FROM EST_PROD_RESSUP_AGENDAMENTO
							WHERE FLAG_NAO_ENVIAR_PBM =1 AND CD_AGD_RESSUP	= @cd_Agenda)
			begin
				DELETE FROM P
				FROM	
					EST_PROD_TRANSF_PRODUTOS P
					INNER JOIN EST_PROD_RC_CLI_CONV A ON
					P.CD_EMP   = A.CD_EMP AND
					P.CD_PROD  = A.CD_PROD
				WHERE
					a.REPOSICAO='S'
			end


			--Seleciona os depositos da agenda.			 
			if @CdCtrDepoSemPool = 0
			begin
				declare c_OrdDepo CURSOR FAST_FORWARD FOR
				SELECT CD_CTR_DEPO, CD_FILIAL_DEPO
				FROM EST_PROD_RESSUP_AGENDAMENTO_PRC_FILIAL_DEPOSITO 
				WHERE
						CD_EMP	= 1
					AND CD_AGD_RESSUP	= @cd_Agenda
				order by  ORDEM_CD	
			end
			else
			begin
				declare c_OrdDepo CURSOR FAST_FORWARD FOR
				SELECT @CdCtrDepoSemPool , @flDeposito
			end		
			OPEN c_OrdDepo
			FETCH NEXT FROM c_OrdDepo INTO @cd_ctrDepo,@FilialDeposito

			WHILE @@FETCH_STATUS = 0
			BEGIN
				PRINT '%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%';
				PRINT convert(varchar, getdate(), 108)
				PRINT 'CD_CTR_DEPO: ' + CONVERT(VARCHAR, @cd_ctrDepo)
				PRINT 'AGENDA: ' + CONVERT(VARCHAR, @cd_Agenda) 
				
				INSERT INTO GLB_EXEC_LOG_ROTINAS (DT_LOG,DT_HR_LOG,MSG_LOG,OPERADOR,LINHA,ROTINA,ROTINA_AUX,PROCESSO)	
					VALUES (GETDATE(),GETDATE(),'Executa ressupririmento CD_CTR_DEPO: ' + CONVERT(VARCHAR, @cd_ctrDepo) ,'EXECUTE',252,'P_GERA_RESSUPRIMENTO_POOL_DEPOSITOS','P_GERA_RESSUPRIMENTO_DEPOSITO_FILIAL','RESSUPRIMENTO')

				EXECUTE P_GERA_RESSUPRIMENTO_DEPOSITO_FILIAL  @CD_EMP					 =1
																	,@CD_FILIAL				 =0
																	,@CONSULTA				 =0
																	,@PERC_FACE				 =100
																	,@CD_PROD				 =NULL
																	,@CD_CTR_DEPO			 =@cd_ctrDepo
																	,@CD_CTR_DEPO_AUX		 =NULL
																	,@DIAS_ACRESCENTAR_RESSUP=@DIAS_RES_ACRESCENTAR
																	,@POOL_RESSUPRIMENTO	 =1
																	,@CD_AGENDA				 =@cd_Agenda;				 													
				print '%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%' 
				print '.... Fim ... Time ' + convert(varchar, getdate(),108);
				print '%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%'

				BEGIN TRY
					--EXEC P_EST_PROD_PENDENCIA_ENTRADA_POOL; 
					print 'Pendencias deposito ' + convert(varchar, @FilialDeposito)

					INSERT INTO GLB_EXEC_LOG_ROTINAS (DT_LOG,DT_HR_LOG,MSG_LOG,OPERADOR,LINHA,ROTINA,ROTINA_AUX,PROCESSO)	
						VALUES (GETDATE(),GETDATE(),'Executa pendencia deposito ' + convert(varchar, @FilialDeposito) ,'EXECUTE',273,'P_GERA_RESSUPRIMENTO_POOL_DEPOSITOS','P_EST_PROD_PENDENCIA_ENTRADA_FILIAL','RESSUPRIMENTO')


					EXECUTE dbo.P_EST_PROD_PENDENCIA_ENTRADA_FILIAL @CD_EMP, @FilialDeposito;
					
				END TRY
				BEGIN CATCH END CATCH

				FETCH NEXT FROM c_OrdDepo INTO @cd_ctrDepo,@FilialDeposito
				
			END
			CLOSE c_OrdDepo ;
			DEALLOCATE c_OrdDepo ; 

			FETCH NEXT FROM c_Agendas INTO @cd_Agenda, @ordem, @CdCtrDepoSemPool,@FlDeposito  ;
		END

	CLOSE c_Agendas;
	DEALLOCATE c_Agendas; 
	
-----------------------------------------------------------------------------------
	-- Mata as demandas do pool
	update EST_PROD_TRANSF_GERAL set STS_TRANSF =2 where STS_TRANSF =0;

-----------------------------------------------------------------------------------
	--Transforma os ressuprimentos em pedido eletronico
	print '============== Transforma os ressuprimentos em pedido eletronico ==============='

	INSERT INTO GLB_EXEC_LOG_ROTINAS (DT_LOG,DT_HR_LOG,MSG_LOG,OPERADOR,LINHA,ROTINA,ROTINA_AUX,PROCESSO)	
		VALUES (GETDATE(),GETDATE(),'Transforma os ressuprimentos em pedido eletronico' ,'EXECUTE',302,'P_GERA_RESSUPRIMENTO_POOL_DEPOSITOS','P_GERA_EST_PED_ELTR_EST_PROD_TRANSF_POOL','RESSUPRIMENTO')

	EXECUTE P_GERA_EST_PED_ELTR_EST_PROD_TRANSF_POOL 1;
	print '============== Transforma os ressuprimentos em pedido eletronico ==============='

-----------------------------------------------------------------------------------	  
END TRY 
BEGIN CATCH
    DECLARE	
		  @mensagemErro	  VARCHAR(255),
		  @severidadeErro	  INT,
		  @estadoErro		  INT;		
    SELECT	@mensagemErro = ERROR_MESSAGE(), 
			@severidadeErro = ERROR_SEVERITY(), 
			@estadoErro = ERROR_STATE();
    
    INSERT INTO ADM_ERRO (numero , severidade , estado ,  
					   rotina , linha , mensagem , dtErro)
			   SELECT ERROR_NUMBER() AS numero
					, @severidadeErro AS severidade
					, @estadoErro AS estado
					, 'Rotina P_EST_PROD_PENDENCIA_ENTRADA ' AS rotina
					, ERROR_LINE() AS linha
					, @mensagemErro  AS mensagem
					, GETDATE() AS dtErro; 
    RAISERROR (@mensagemErro, @severidadeErro, @estadoErro);
END CATCH   